<?php

namespace App\Http\Middleware;

use App\Providers\RouteServiceProvider;
use Closure;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;

class RedirectIfAuthenticated
{
    /**
     * Handle an incoming request.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \Closure(\Illuminate\Http\Request): (\Illuminate\Http\Response|\Illuminate\Http\RedirectResponse)  $next
     * @param  string|null  ...$guards
     * @return \Illuminate\Http\Response|\Illuminate\Http\RedirectResponse
     */
    public function handle(Request $request, Closure $next, ...$guards)
    {
        $guards = empty($guards) ? [null] : $guards;

        foreach ($guards as $guard) {
            if (Auth::guard($guard)->check()) {
                // return redirect(RouteServiceProvider::HOME);
                switch (Auth::user()->role) {
                    case 0:
                        return redirect('/admin')->with(['success' => 'لقد تم اعادة تعيين كلمة المرور الخاصة بك بنجاح, يمكنك الان الاستفادة من خدمات المنصة']);
                        break;
    
                    case 1:
                        return redirect('/trainer')->with(['success' => 'لقد تم اعادة تعيين كلمة المرور الخاصة بك بنجاح, يمكنك الان الاستفادة من خدمات المنصة']);
    
                        break;
    
                    case 2:
                        return redirect('/student')->with(['success' => 'لقد تم اعادة تعيين كلمة المرور الخاصة بك بنجاح, يمكنك الان الاستفادة من خدمات المنصة']);
    
                        break;
                    case 3:
                        return redirect('/coordinator')->with(['success' => 'لقد تم اعادة تعيين كلمة المرور الخاصة بك بنجاح, يمكنك الان الاستفادة من خدمات المنصة']);
    
                        break;
                    default:
                        return redirect('/');
    
                        break;
                }
                // return redirect()->back();
            }
        }

        return $next($request);
    }
}
